<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$services = [];
$error = '';

try {
    $conn = getAdminDBConnection();

    // Fetch all services
    $stmt = $conn->prepare("SELECT id, title, category, price, features, popular FROM services ORDER BY title ASC");
    if ($stmt === false) {
        throw new Exception('Prepare services statement failed: ' . $conn->error);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $services[] = $row;
        }
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'حدث خطأ أثناء تحميل بيانات الخدمات: ' . $e->getMessage();
}

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="mb-0">إدارة الخدمات</h3>
            <a href="admin_add_service.php" class="btn btn-primary btn-sm">إضافة خدمة جديدة</a>
        </div>
        <div class="card-body">
            <?php 
            $message = $_GET['message'] ?? '';
            $message_type = $_GET['type'] ?? '';
            if (!empty($message)): ?>
                <div class="alert alert-<?= htmlspecialchars($message_type) ?>" role="alert">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>
            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>الاسم</th>
                            <th>الفئة</th>
                            <th>السعر</th>
                            <th>المميزات</th>
                            <th>شائع</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($services)): ?>
                            <?php foreach ($services as $service): ?>
                            <tr>
                                <td><?= htmlspecialchars($service['id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($service['title'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($service['category'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($service['price'] ?? 'N/A') ?> $</td>
                                <td><?= htmlspecialchars($service['features'] ?? 'N/A') ?></td>
                                <td><?= ($service['popular'] ?? false) ? 'نعم' : 'لا' ?></td>
                                <td>
                                    <a href="admin_edit_service.php?id=<?= htmlspecialchars($service['id'] ?? '') ?>" class="btn btn-sm btn-info">تعديل</a>
                                    <a href="admin_delete_service.php?id=<?= htmlspecialchars($service['id'] ?? '') ?>" class="btn btn-sm btn-danger">حذف</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">لا توجد خدمات لعرضها.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?> 